

<?php $__env->startSection('content'); ?>
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <!-- product list start -->
            <section class="app-user-list">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center justify-content-between">
                                <div>
                                    <h3 class="fw-bolder mb-75"><?php echo e($products->count()); ?></h3>
                                    <span>Total Products</span>
                                </div>
                                <div class="avatar bg-light-primary p-50">
                                    <span class="avatar-content">
                                        <i data-feather="user" class="font-medium-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-header">
                        
                        <a href="<?php echo e(route('product.create')); ?>" class="btn btn-primary">Add product</a>
                        
                    </div>
                    
                    <div class="card-datatable card-body table-responsive pt-0">
                        
                        <table class="table" id="productsTbl">
                            <thead class="table-light">
                                <tr>
                                    <th></th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Pump</th>
                                    <th>Price per Litre</th>
                                    <th>Category</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i+1); ?></td>
                                        <td><?php echo e($product->name); ?></td>
                                        <td><?php echo e($product->code); ?></td>
                                        <td><?php echo e($product->pump ? $product->pump->name : ''); ?></td>
                                        <td><?php echo e(+$product->price); ?></td>
                                        <td><?php echo e($product->category); ?></td>
                                        
                                        <td>
                                            <?php echo $__env->make('products.partials.action_buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </td>
                                        
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- Modal to add new user starts-->
                     <!-- Modal to add new user Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- products list ends -->

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-scripts'); ?>
    <script>
       $.ajaxSetup({headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" }});
        $('#productsTbl').DataTable();
       
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\spine\Documents\others\petrol_dashboard\resources\views/products/index.blade.php ENDPATH**/ ?>