

<?php $__env->startSection('content'); ?>
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center justify-content-between">
                                <div>
                                    <h3 class="fw-bolder mb-75"><?php echo e($pumps->count()); ?></h3>
                                    <span>Total pumps</span>
                                </div>
                                <div class="avatar bg-light-primary p-50">
                                    <span class="avatar-content">
                                        <i data-feather="user" class="font-medium-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-header">
                        <button type="button" id="btnPop" class="btn btn-primary" style="margin-right: 0;">
                            Add Pump
                        </button>
                        
                    </div>
                    
                    <div class="card-datatable card-body table-responsive pt-0">
                        
                        <table class="table" id="pumpsTbl">
                            <thead class="table-light">
                                <tr>
                                    <th></th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Description</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $pumps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $pump): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i+1); ?></td>
                                        <td><?php echo e($pump->name); ?></td>
                                        <td><?php echo e($pump->code); ?></td>
                                        <td><?php echo e($pump->description); ?></td>
                                        <td><?php echo e($pump->created_at); ?></td>
                                        <td>
                                            <?php echo $__env->make('pumps.partials.action_buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </td>
                                        
                                    </tr>
                                    <div class="modal fade" id="exampleModal<?php echo e($pump->id); ?>" tabindex="0" aria-labelledby="exampleModalLabel<?php echo e($pump->id); ?>" aria-hidden="false">
                                        <div class="modal-dialog">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h5 class="modal-title" id="exampleModalLabel<?php echo e($pump->id); ?>">Edit pump</h5>
                                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?php echo e(route('pump.update', ['pump' => $pump->id])); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-name">Pump Name</label>
                                                        <input type="text" class="form-control" id="editname" value="<?php echo e($pump->name); ?>" placeholder="eg. Pump 1" name="name" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="code">Pump Code</label>
                                                        <input type="text" class="form-control" id="editcode" placeholder="eg. P1" value="<?php echo e($pump->code); ?>" name="code" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="description">Description</label>
                                                        <input type="text" class="form-control" id="editdescription" placeholder="eg. Describe" value="<?php echo e($pump->description); ?>" name="description" />
                                                    </div>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </form>
                                            </div>
                                            
                                            
                                          </div>
                                        </div>
                                      </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- Modal to add new pump starts-->
                    <?php echo $__env->make('pumps.partials.pump_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('pumps.partials.pump_edit_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Modal to add new user Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- pumps list ends -->

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-scripts'); ?>
    <script>
       $.ajaxSetup({headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" }});
        $('#pumpsTbl').DataTable();
        $('#btnPop').click(function () {
            // Show the modal
            $('#pumpModal').modal('show');
        });
        $('.btnEdit').on('click', function() {

            var pumpId = $(this).data('pump-id');
            var pump = <?php echo json_encode($pumps, 15, 512) ?>;
            console.log(pump, pumpId);
            // Find the pump by ID
            var selectedpump = pump.find(u => u.id === pumpId);
            console.log(selectedpump);

            // Populate the modal with pump data
            $('#editname').val(selectedpump.name);
            $('#editcode').val(selectedpump.code);
            $('#editdescription').val(selectedpump.description);
            $('#editpumpId').val(selectedpump.id);
            $('#editModal').modal('show');
        });

        $("#editForm").submit(function (e) {
            e.preventDefault();
            var formData = $(this).serialize();
            // console.log(formData);

            // Submit form data via AJAX
            $.ajax({
                url: "<?php echo e(route('users.update')); ?>",
                type: "post",
                data: formData,
                success: function (data) {
                    // Handle success, e.g., close the modal or update the table
                    $("#editModal").modal("hide");
                    // Update the table or perform any other necessary actions
                },
                error: function (error) {
                    console.log("Error updating user:", error);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\spine\Documents\others\petrol_dashboard\resources\views/pumps/index.blade.php ENDPATH**/ ?>