

<?php $__env->startSection('content'); ?>
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <?php if(session('flash_success')): ?>
                <div class="alert bg-success alert-dismissible m-1" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <strong>Success!</strong> <?php echo session('flash_success'); ?>

                </div>
            <?php endif; ?>
            <?php if(session('flash_error')): ?>
                <div class="alert bg-danger alert-dismissible m-1" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <strong>Error!</strong> <?php echo session('flash_error'); ?>

                </div>
            <?php endif; ?>
        </div>
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center justify-content-between">
                                <div>
                                    <h3 class="fw-bolder mb-75"><?php echo e($users->count()); ?></h3>
                                    <span>Total Users</span>
                                </div>
                                <div class="avatar bg-light-primary p-50">
                                    <span class="avatar-content">
                                        <i data-feather="user" class="font-medium-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center justify-content-between">
                                <div>
                                    <h3 class="fw-bolder mb-75"><?php echo e($users->where('status','active')->count()); ?></h3>
                                    <span>Active Users</span>
                                </div>
                                <div class="avatar bg-light-danger p-50">
                                    <span class="avatar-content">
                                        <i data-feather="user-plus" class="font-medium-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center justify-content-between">
                                <div>
                                    <h3 class="fw-bolder mb-75"><?php echo e($users->where('status','inactive')->count()); ?></h3>
                                    <span>Inactive Users</span>
                                </div>
                                <div class="avatar bg-light-success p-50">
                                    <span class="avatar-content">
                                        <i data-feather="user-check" class="font-medium-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center justify-content-between">
                                <div>
                                    <h3 class="fw-bolder mb-75"><?php echo e($users->where('status','pending')->count()); ?></h3>
                                    <span>Pending Users</span>
                                </div>
                                <div class="avatar bg-light-warning p-50">
                                    <span class="avatar-content">
                                        <i data-feather="user-x" class="font-medium-4"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-header">
                        <button type="button" id="btnPop" class="btn btn-primary" style="margin-right: 0;">
                            Add User
                        </button>
                        
                    </div>
                    
                    <div class="card-datatable card-body table-responsive pt-0">
                        
                        <table class="table" id="usersTbl">
                            <thead class="table-light">
                                <tr>
                                    <th></th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Code</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i+1); ?></td>
                                        <td><?php echo e($user->name); ?></td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td><?php echo e($user->code); ?></td>
                                        <td><?php echo e(@$user->role->name); ?></td>
                                        <td>
                                            <?php
                                                $badge_type = $user->status == 'active'? 'badge-success' : 'badge-warning';
                                                $link = '<span data-id="'. $user->id .'" class="badge '. $badge_type .'">'. ucfirst($user->status) .'</span>';
                                            ?> 
                                            <?php echo e(ucfirst($user->status)); ?></td>
                                        <td>
                                            
                                            <a class="btn btn-sm btn-primary" href="<?php echo e(route('user.show', $user->id)); ?>"><i data-feather="eye"></i></a>
                                            <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo e($user->id); ?>">
                                                <i data-feather="edit"></i>
                                              </button>
                                            
                                            <form action="<?php echo e(route('user.destroy', ['user' => $user->id])); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger" type="submit"><i data-feather="trash"></i></button>
                                                
                                            </form>
                                            
                                        </td>
                                        
                                    </tr>
                                    
                                    <div class="modal fade" id="exampleModal<?php echo e($user->id); ?>" tabindex="0" aria-labelledby="exampleModalLabel<?php echo e($user->id); ?>" aria-hidden="false">
                                        <div class="modal-dialog">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h5 class="modal-title" id="exampleModalLabel<?php echo e($user->id); ?>">Edit User</h5>
                                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="<?php echo e(route('user.update', ['user' => $user->id])); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-fullname">Full Name</label>
                                                        <input type="text" class="form-control dt-full-name" value="<?php echo e($user->name); ?>" id="fullname" placeholder="John Doe" name="fullname" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-code">Code</label>
                                                        <input type="text" id="code" class="form-control dt-code" value="<?php echo e($user->code); ?>"  placeholder="123456" name="code" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-email">Email</label>
                                                        <input type="text" id="email" class="form-control dt-email" value="<?php echo e($user->email); ?>"  placeholder="john.doe@example.com" name="email" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-contact">Contact</label>
                                                        <input type="text" id="contact" class="form-control dt-contact" value="<?php echo e($user->phone_number); ?>"  placeholder="+2557 123 456 78" name="phone_number" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="user-role">User Role</label>
                                                        <select id="role" name="role_id" class="select2 form-select">
                                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($role->id); ?>" <?php echo e($role->id == @$user->role_id ? 'selected' : ''); ?>><?php echo e($role->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="status">User Status</label>
                                                        <select id="status" name="status" class="select2 form-select">
                                                            <?php $__currentLoopData = ['pending','active','inactive']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($status); ?>"><?php echo e(ucfirst($status)); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </form>
                                            </div>
                                            
                                            
                                          </div>
                                        </div>
                                      </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- Modal to add new user starts-->
                    <?php echo $__env->make('users.partials.user_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    
                      
                      <!-- Modal -->
                      
                    
                    <!-- Modal to add new user Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- users list ends -->

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-scripts'); ?>
    <script>
       $.ajaxSetup({headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" }});
        $('#usersTbl').DataTable();
        $('#btnPop').click(function () {
            // Show the modal
            $('#userModal').modal('show');
        });
        $('.btnEdit').on('click', function() {

            var userId = $(this).data('user-id');
            var user = <?php echo json_encode($users, 15, 512) ?>;
            // console.log(user, userId);
            // // Find the user by ID
            var selectedUser = user.find(u => u.id === userId);
            // console.log(selectedUser);

            // Populate the modal with user data
            // $('#fullname').val(selectedUser.name);
            // $('#email').val(selectedUser.email);
            // $('#code').val(selectedUser.code);
            // $('#status').val(selectedUser.status);
            // $('#role').val(selectedUser.role_id);
            // $('#contact').val(selectedUser.phone_number);
            // $('#editUserId').val(selectedUser.id);
            // $(`#editModal${selectedUser.id}`).modal('show');
        });

        $("#editForm").submit(function (e) {
            e.preventDefault();
            var formData = $(this).serialize();
            // console.log(formData);

            // Submit form data via AJAX
            $.ajax({
                url: "<?php echo e(route('users.update')); ?>",
                type: "post",
                data: formData,
                success: function (data) {
                    // Handle success, e.g., close the modal or update the table
                    $("#editModal").modal("hide");
                    // Update the table or perform any other necessary actions
                },
                error: function (error) {
                    console.log("Error updating user:", error);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\spine\Documents\others\petrol_dashboard\resources\views/users/index.blade.php ENDPATH**/ ?>